/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.MachineId;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class FcsDatagram {
    private static final String TRACE_MASKD = "XFCSFDGD";
    private static final String TRACE_MASKF = "XFCSFDGF";
    private static final String TRACE_MASKT = "XFCSFDGT";
    private static final int MACHINE_NAME_LENGTH = 16;
    private static final int GROUP_NAME_LENGTH = 16;
    private static final int VERSION_LENGTH = 8;
    private static final int TYPE_LENGTH = 5;
    private static final int FCS_VERSION_LENGTH = 4;
    private static final int NIC_ADDR_LENGTH = 4;
    private static final int ACTION_LENGTH = 1;
    public static final int DATAGRAM_BUFFER_SIZE = 504;
    public static final int ACTION_QUERY = 1;
    public static final int ACTION_RESPONSE = 2;
    public static final int ACTION_UPDATE = 3;
    private MachineId machineId;
    private int action;

    public FcsDatagram(MachineId machineId, int action) {
        this.machineId = machineId;
        this.action = action;
    }

    public FcsDatagram(DatagramPacket packet) throws FcsException {
        try {
            byte[] buffer = packet.getData();
            byte[] machineNameBytes = new byte[16];
            byte[] groupBytes = new byte[16];
            byte[] versionBytes = new byte[8];
            byte[] typeBytes = new byte[5];
            byte[] fcsVersionBytes = new byte[4];
            byte[] lan1AddrBytes = new byte[4];
            byte[] actionBytes = new byte[1];
            int offset = 0;
            System.arraycopy(buffer, offset, machineNameBytes, 0, machineNameBytes.length);
            System.arraycopy(buffer, offset += 16, groupBytes, 0, groupBytes.length);
            System.arraycopy(buffer, offset += 16, versionBytes, 0, versionBytes.length);
            System.arraycopy(buffer, offset += 8, typeBytes, 0, typeBytes.length);
            System.arraycopy(buffer, offset += 5, fcsVersionBytes, 0, fcsVersionBytes.length);
            System.arraycopy(buffer, offset += 4, lan1AddrBytes, 0, lan1AddrBytes.length);
            System.arraycopy(buffer, offset += 4, actionBytes, 0, actionBytes.length);
            String lan1String = "";
            int i = 0;
            while (i < lan1AddrBytes.length) {
                lan1String = lan1AddrBytes[i] < 0 ? lan1String + (lan1AddrBytes[i] + 256) : lan1String + lan1AddrBytes[i];
                if (i < lan1AddrBytes.length - 1) {
                    lan1String = lan1String + ".";
                }
                ++i;
            }
            this.machineId = new MachineId(new String(machineNameBytes).trim(), new String(groupBytes).trim(), new Double(new String(versionBytes).trim()), new Integer(new String(typeBytes).trim()), new Integer(new String(fcsVersionBytes).trim()), new InetAddress[]{InetAddress.getByName(lan1String)}, new boolean[]{true});
            this.action = new Integer(new String(actionBytes).trim());
        }
        catch (Exception e) {
            throw new FcsException(e);
        }
    }

    public boolean isQuery() {
        return this.action == 1;
    }

    public boolean isResponse() {
        return this.action == 2;
    }

    public boolean isUpdate() {
        return this.action == 3;
    }

    public MachineId getMachineId() {
        return this.machineId;
    }

    public DatagramPacket asPacket() {
        byte[] buffer = new byte[504];
        byte[] machineNameBytes = this.machineId.getName().getBytes();
        byte[] groupBytes = this.machineId.getGroup().getBytes();
        byte[] versionBytes = new Double(this.machineId.getVersion()).toString().getBytes();
        byte[] typeBytes = new Integer(this.machineId.getType()).toString().getBytes();
        byte[] fcsVersionBytes = new Integer(this.machineId.getFcsVersion()).toString().getBytes();
        byte[] lan1AddrBytes = this.machineId.getNicAddresses()[0].getAddress();
        byte[] actionBytes = new Integer(this.action).toString().getBytes();
        int offset = 0;
        System.arraycopy(machineNameBytes, 0, buffer, offset, Math.min(machineNameBytes.length, 16));
        System.arraycopy(groupBytes, 0, buffer, offset += 16, Math.min(groupBytes.length, 16));
        System.arraycopy(versionBytes, 0, buffer, offset += 16, Math.min(versionBytes.length, 8));
        System.arraycopy(typeBytes, 0, buffer, offset += 8, Math.min(typeBytes.length, 5));
        System.arraycopy(fcsVersionBytes, 0, buffer, offset += 5, Math.min(fcsVersionBytes.length, 4));
        System.arraycopy(lan1AddrBytes, 0, buffer, offset += 4, Math.min(lan1AddrBytes.length, 4));
        System.arraycopy(actionBytes, 0, buffer, offset += 4, Math.min(actionBytes.length, 1));
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        return packet;
    }
}

